(function ($) {
  "use strict";

  var KitifyCategoryMenu = function ($el) {
    var $menu = $el.find(".kitify-category-menu");
    var $menu_item = $el.find(
      ".kitify-category-menu ul.menu > li.menu-item-has-children"
    );
    var $menu_first = $el.find(
      ".kitify-category-menu ul.menu > li:first-of-type"
    );
    $menu.on("click", ".kitify-category-menu__title", function (e) {
      $(this).closest($menu).toggleClass("show");
    });
    $(document.body).on("click", "div", function (e) {

      var $target = $(e.target);

      if ($target.is($menu) || $target.closest($menu).length) {
        return;
      }
      $menu.removeClass("show");
    });
    $menu_first.addClass("is-active");
    $menu_item.hover(function () {
      $menu_item.removeClass("is-active");
      $(this).addClass("is-active");
    });
  };

  $(window).on("elementor/frontend/init", function () {
    window.elementorFrontend.hooks.addAction(
      "frontend/element_ready/kitify-category-menu.default",
      function ($scope) {
        KitifyCategoryMenu($scope);
      }
    );
  });
})(jQuery);
