'use strict';

Vue.component( 'kitify-general-settings', {

	template: '#kitify-dashboard-kitify-general-settings',

	data: function() {
		return {
			pageOptions: window.KitifySettingsConfig.settingsData,
			preparedOptions: {},
			savingStatus: false,
			ajaxSaveHandler: null,
		};
	},

	watch: {
		pageOptions: {
			handler( options ) {
				let prepared = {};

				for ( let option in options ) {

					if ( options.hasOwnProperty( option ) ) {
						prepared[ option ] = options[option]['value'];
					}
				}

				this.preparedOptions = prepared;
				this.saveOptions();
			},
			deep: true
		}
	},

	methods: {

		updateSetting: function ( value, setting ){
			this.preparedOptions[setting] = value;
			this.saveOptions();
		},

		saveOptions: function() {

			var self = this;

			self.savingStatus = true;

			self.ajaxSaveHandler = jQuery.ajax( {
				type: 'POST',
				headers: {
					'X-WP-Nonce': wpApiSettings.nonce,
				},
				url: window.KitifySettingsConfig.settingsApiUrl,
				dataType: 'json',
				data: self.preparedOptions,
				beforeSend: function( jqXHR, ajaxSettings ) {

					if ( null !== self.ajaxSaveHandler ) {
						self.ajaxSaveHandler.abort();
					}
				},
				success: function( responce, textStatus, jqXHR ) {
					self.savingStatus = false;

					if ( 'success' === responce.status ) {
						self.$CXNotice.add( {
							message: responce.message,
							type: 'success',
							duration: 3000,
						} );
					}

					if ( 'error' === responce.status ) {
						self.$CXNotice.add( {
							message: responce.message,
							type: 'error',
							duration: 3000,
						} );
					}
				}
			} );
		},
	}
} );

Vue.component( 'kitify-integrations-settings', {

	template: '#kitify-dashboard-kitify-integrations-settings',

	data: function() {
		return {
			pageOptions: window.KitifySettingsConfig.settingsData,
			preparedOptions: {},
			savingStatus: false,
			ajaxSaveHandler: null,
		};
	},

	watch: {
		pageOptions: {
			handler( options ) {
				let prepared = {};

				for ( let option in options ) {

					if ( options.hasOwnProperty( option ) ) {
						prepared[ option ] = options[option]['value'];
					}
				}

				this.preparedOptions = prepared;

				this.saveOptions();
			},
			deep: true
		}
	},

	methods: {

		saveOptions: function() {

			var self = this;

			self.savingStatus = true;

			self.ajaxSaveHandler = jQuery.ajax( {
				type: 'POST',
				headers: {
					'X-WP-Nonce': wpApiSettings.nonce,
				},
				url: window.KitifySettingsConfig.settingsApiUrl,
				dataType: 'json',
				data: self.preparedOptions,
				beforeSend: function( jqXHR, ajaxSettings ) {

					if ( null !== self.ajaxSaveHandler ) {
						self.ajaxSaveHandler.abort();
					}
				},
				success: function( responce, textStatus, jqXHR ) {
					self.savingStatus = false;

					if ( 'success' === responce.status ) {
						self.$CXNotice.add( {
							message: responce.message,
							type: 'success',
							duration: 3000,
						} );
					}

					if ( 'error' === responce.status ) {
						self.$CXNotice.add( {
							message: responce.message,
							type: 'error',
							duration: 3000,
						} );
					}
				}
			} );
		},
	}
} );

Vue.component( 'kitify-avaliable-addons', {

	template: '#kitify-dashboard-kitify-avaliable-addons',

	data: function() {
		return {
			pageOptions: window.KitifySettingsConfig.settingsData,
			preparedOptions: {},
			savingStatus: false,
			ajaxSaveHandler: null,
			shouldReload: false,
		};
	},

	watch: {
		pageOptions: {
			handler( options ) {
				let prepared = {};

				for ( let option in options ) {

					if ( options.hasOwnProperty( option ) ) {
						prepared[ option ] = options[option]['value'];
					}
				}
				this.preparedOptions = prepared;
				this.saveOptions();
			},
			deep: true
		}
	},

	methods: {

		updateSetting: function ( value, settings, root_key, model ){
			if( ['portfolio_content_type', 'event_content_type', 'album_content_type'].includes(settings) ){
				this.shouldReload = true;
			}
			model[settings] = value;
			this.preparedOptions[root_key] = model;
			this.saveOptions();
		},

		saveOptions: function() {

			var self = this;

			self.savingStatus = true;

			self.ajaxSaveHandler = jQuery.ajax( {
				type: 'POST',
				headers: {
					'X-WP-Nonce': wpApiSettings.nonce,
				},
				url: window.KitifySettingsConfig.settingsApiUrl,
				dataType: 'json',
				data: self.preparedOptions,
				beforeSend: function( jqXHR, ajaxSettings ) {

					if ( null !== self.ajaxSaveHandler ) {
						self.ajaxSaveHandler.abort();
					}
				},
				success: function( responce, textStatus, jqXHR ) {
					self.savingStatus = false;

					if ( 'success' === responce.status ) {
						self.$CXNotice.add( {
							message: responce.message,
							type: 'success',
							duration: 3000,
						} );

						if(self.shouldReload){
							window.location.reload();
						}
					}

					if ( 'error' === responce.status ) {
						self.$CXNotice.add( {
							message: responce.message,
							type: 'error',
							duration: 3000,
						} );
					}
				}
			} );
		},
	}
} );

Vue.component( 'kitify-fonts-manager', {

	template: '#kitify-dashboard-kitify-fonts-manager',

	data: function() {
		return {
			preparedOptions: {},
			savingStatus: false,
			ajaxSaveHandler: null,
			customFonts: window.KitifySettingsConfig.settingsData.custom_fonts.value
		};
	},

	computed: {
		fieldsList: function() {
			var result = [];
			for ( var i = 0; i < this.customFonts.length; i++ ) {
				result.push( {
					title: this.customFonts[ i ].title || '',
					name: this.customFonts[ i ].name || '',
					type: this.customFonts[ i ].type || '',
					url: this.customFonts[ i ].url || '',
					variations: this.customFonts[ i ].variations || [],
				} );
			}
			return result;
		},
	},

	methods: {
		onInput: function ( value ){
			this.preparedOptions = {
				custom_fonts: value
			};
		},
		saveOptions: function() {

			var self = this;

			self.savingStatus = true;


			self.ajaxSaveHandler = jQuery.ajax( {
				type: 'POST',
				headers: {
					'X-WP-Nonce': wpApiSettings.nonce,
				},
				url: window.KitifySettingsConfig.settingsApiUrl,
				dataType: 'json',
				data: JSON.stringify(self.preparedOptions),
				contentType: 'application/json',
				beforeSend: function( jqXHR, ajaxSettings ) {
					if ( null !== self.ajaxSaveHandler ) {
						self.ajaxSaveHandler.abort();
					}
				},
				success: function( responce, textStatus, jqXHR ) {
					self.savingStatus = false;

					if ( 'success' === responce.status ) {
						self.$CXNotice.add( {
							message: responce.message,
							type: 'success',
							duration: 3000,
						} );
					}

					if ( 'error' === responce.status ) {
						self.$CXNotice.add( {
							message: responce.message,
							type: 'error',
							duration: 3000,
						} );
					}
				}
			} );
		},
	}
} );

Vue.component( 'kitify-swatches', {

	template: '#kitify-dashboard-kitify-swatches',

	data: function() {
		return {
			pageOptions: window.KitifySettingsConfig.settingsData,
			preparedOptions: {},
			savingStatus: false,
			ajaxSaveHandler: null,
		};
	},

	watch: {
		pageOptions: {
			handler( options ) {
				let prepared = {};

				for ( let option in options ) {

					if ( options.hasOwnProperty( option ) ) {
						prepared[ option ] = options[option]['value'];
					}
				}

				this.preparedOptions = prepared;

				this.saveOptions();
			},
			deep: true
		}
	},

	methods: {

		saveOptions: function() {

			var self = this;

			self.savingStatus = true;

			self.ajaxSaveHandler = jQuery.ajax( {
				type: 'POST',
				headers: {
					'X-WP-Nonce': wpApiSettings.nonce,
				},
				url: window.KitifySettingsConfig.settingsApiUrl,
				dataType: 'json',
				data: self.preparedOptions,
				beforeSend: function( jqXHR, ajaxSettings ) {

					if ( null !== self.ajaxSaveHandler ) {
						self.ajaxSaveHandler.abort();
					}
				},
				success: function( responce, textStatus, jqXHR ) {
					self.savingStatus = false;

					if ( 'success' === responce.status ) {
						self.$CXNotice.add( {
							message: responce.message,
							type: 'success',
							duration: 3000,
						} );
					}

					if ( 'error' === responce.status ) {
						self.$CXNotice.add( {
							message: responce.message,
							type: 'error',
							duration: 3000,
						} );
					}
				}
			} );
		},
	}
} );