<?php

/**
 * Class: Kitify_Category_Menu
 * Name: Category Menu
 * Slug: kitfy-category-menu
 */

 namespace Elementor;

 if (!defined('WPINC')) {
     die;
 }

class Kitify_Category_Menu extends Kitify_Base {
    protected function enqueue_addon_resources(){
        if(!kitify_settings()->is_combine_js_css()){
            $this->add_script_depends( 'kitify-w__category-menu' );
        }
    }
    public function get_name() {
      return 'kitify-category-menu';
    }
    public function get_categories() {
      return [ 'kitify-builder' ];
    } 
    protected function get_widget_title() {
      return esc_html__( 'Category Menu', 'kitify' );
    }
    public function get_icon() {
      return 'kitify-icon-nav-menu';
    }
    protected function register_controls() {
        $this->start_controls_section(
            'section_menu',
            array(
                'label' => esc_html__( 'Menu', 'kitify' ),
            )
        );
        $menus   = $this->get_available_menus();
        $default = '';

        if ( ! empty( $menus ) ) {
            $ids     = array_keys( $menus );
            $default = $ids[0];
        }

        $this->add_control(
            'category_menu',
            array(
                'label'   => esc_html__( 'Select Menu', 'kitify' ),
                'type'    => Controls_Manager::SELECT,
                'default' => $default,
                'options' => $menus,
            )
        );
        $this->_add_advanced_icon_control(
        'category_menu_icon',
            array(
                'label'       => esc_html__( 'Menu Icon', 'kitify' ),
                'label_block' => false,
                'type'        => Controls_Manager::ICON,
                'skin'        => 'inline',
                'default'     => 'dlicon ui-2_menu-34',
                'fa5_default' => array(
                    'value'   => 'dlicon ui-2_menu-34',
                    'library' => 'dlicon',
                ),
            )
        );
        $this->add_control(
        'category_menu_title',
            array(
                'label'   => esc_html__( 'Menu Title', 'kitify' ),
                'type'    => Controls_Manager::TEXT,
                'default' => esc_html__( 'Categories', 'kitify' ),
                'dynamic' => array( 'active' => true ),
            )
        );
        $this->add_control(
            'category_menu_arrow',
            array(
                'label'   => esc_html__( 'Arrow Icon', 'kitify' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'novaicon-down-arrow',
                'options' => $this->dropdown_arrow_icons_list(),
            )
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_menu_dropdown',
            array(
                'label' => esc_html__( 'Dropdown Content', 'kitify' ),
            )
        );
        $this->add_control(
            'category_menu_dropdown_icon',
            array(
                'label'   => esc_html__( 'Dropdown Icon', 'kitify' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'novaicon-down-arrow',
                'options' => $this->dropdown_arrow_icons_list(),
            )
        );
        $this->end_controls_section();
        $css_scheme = \apply_filters(
            'kitify/category-menu/css-scheme',
            array(
                'menu_title'                        => '.kitify-category-menu__title',
                'menu_title_icon'                   => '.kitify-category-menu__title-icon',
                'menu_title_text'                   => '.kitify-category-menu__title-text',
                'menu_dropdown'                     => '.kitify-category-menu.show .kitify-category-menu__content',
                'menu_dropdown_item_active'         => '.kitify-category-menu__content .kitify-category-menu__content-menu ul.menu>li.is-active>a',
                'menu_dropdown_right'               => '.kitify-category-menu__content .kitify-category-menu__content-menu .mega-menu-container',
            )
        );

        $this->start_controls_section(
            'title_style',
            array(
                'label'      => esc_html__( 'Title', 'kitify' ),
                'tab'        => Controls_Manager::TAB_STYLE,
                'show_label' => false,
            )
        );
        $this->add_responsive_control(
        'title_height',
            array(
                'label'      => esc_html__( 'Height', 'kitify' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => array( 'px', '%' ),
                'range'      => array(
                    'px' => array(
                        'min' => 20,
                        'max' => 200,
                    ),
                ),
                'selectors'  => array(
                    '{{WRAPPER}} '. $css_scheme['menu_title'] => 'height: {{SIZE}}{{UNIT}};',
                ),
            ),
        );
        $this->add_control(
            'title_bg_color',
            array(
                'label'  => esc_html__( 'Background Color', 'kitify' ),
                'type'   => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} ' => '--kitify-category-menu-title-bg: {{VALUE}}',
                ),
            ),
        );
        $this->add_control(
            'title_text_color',
            array(
                'label'  => esc_html__( 'Color', 'kitify' ),
                'type'   => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} ' => '--kitify-category-menu-title-color: {{VALUE}}',
                ),
            ),
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            array(
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} '. $css_scheme['menu_title_text'],
            ),
        );
        $this->_add_responsive_control(
        'title_padding',
            array(
                'label'      => esc_html__( 'Padding', 'kitify' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => array( 'px', '%', 'em' ),
                'selectors'  => array(
                    '{{WRAPPER}} ' . $css_scheme['menu_title'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ),
            ),
        );
        $this->add_control(
            'title_radius',
            array(
                'label'      => esc_html__( 'Border Radius', 'kitify' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => array( 'px', '%' ),
                'selectors'  => array(
                    '{{WRAPPER}} ' . $css_scheme['menu_title'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ),
            ),
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'dropdown_style',
            array(
                'label'      => esc_html__( 'Dropdown Content', 'kitify' ),
                'tab'        => Controls_Manager::TAB_STYLE,
                'show_label' => false,
            )
        );
        $this->add_control(
            'drop_bg_color',
            array(
                'label'  => esc_html__( 'Background Color', 'kitify' ),
                'type'   => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} ' => '--kitify-category-menu-nav-parent-bg: {{VALUE}}',
                ),
            ),
        );
       $this->add_control(
            'drop_active_bg_color',
            array(
                'label'  => esc_html__( 'Active Color', 'kitify' ),
                'type'   => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} ' => '--kitify-category-menu-nav-lv1-active: {{VALUE}}',
                ),
            ),
        );
        $this->_add_responsive_control(
        'lv1_width',
            array(
                'label'      => esc_html__( 'Content width', 'kitify' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => array( 'px', '%' ),
                'range'      => array(
                    'px' => array(
                        'min' => 20,
                        'max' => 500,
                    ),
                ),
                'selectors'  => array(
                    '{{WRAPPER}}' => '--kitify-category-menu-content-w: {{SIZE}}{{UNIT}};',
                ),
            ),
        );  
        $this->_add_responsive_control(
        'lv2_width',
            array(
                'label'      => esc_html__( 'Content right width', 'kitify' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => array( 'px', '%' ),
                'range'      => array(
                    'px' => array(
                        'min' => 20,
                        'max' => 1270,
                    ),
                ),
                'selectors'  => array(
                    '{{WRAPPER}}' => '--kitify-category-menu-content-right-w: {{SIZE}}{{UNIT}};',
                ),
            ),
        );  
        $this->end_controls_section();

    }
    protected function render() {
        $settings = $this->get_settings();

        if ( ! $settings['category_menu'] ) {
            return;
        }
        $check_menu = wp_nav_menu(
            array (
                'menu'              => $settings['category_menu'],
                'echo' => FALSE,
                'fallback_cb' => '__return_false'
            )
        );
        if ( ! $check_menu ) {
            return;
        }
        $title = esc_html__( 'Categories', 'kitify' );
        if ( ! empty( $settings['category_menu_title'] ) ) {
            $title = $settings['category_menu_title'];
        }
        $this->add_render_attribute( 'nav-wrapper', 'class', 'kitify-category-menu');
        echo '<div ' . $this->get_render_attribute_string( 'nav-wrapper' ) . '>';
            echo '<div class="kitify-category-menu__inner">';
                echo '<div class="kitify-category-menu__title">';
                $this->_icon( 'category_menu_icon', '<span class="kitify-category-menu__title-icon">%s</span>' );
                echo '<span class="kitify-category-menu__title-text">' . $title . '</span>';
                printf('<span class="kitify-category-menu__title-arrow"><i class="kitify-icon-arrow %s"></i></span>', $settings['category_menu_arrow'] );
                echo '</div>';
                echo '<div class="kitify-category-menu__wrappper">';
                    echo '<div class="kitify-category-menu__content">';
                        if ( class_exists( '\Novaworks\Core\Modules\Mega_Menu\Walker' ) ) {
                        echo '<nav class="kitify-category-menu__content-menu">';
                        wp_nav_menu(array(
                            'menu'              => $settings['category_menu'],
                            'container'         => false,
                            'menu_class'        => 'menu',
                            'link_before'       => '',
                            'link_after'        => '',
                            'walker'			=> new \Novaworks\Core\Modules\Mega_Menu\Walker(),
                            'widget_settings' => array(
                                'dropdown_icon'   => $settings['category_menu_dropdown_icon'],
                            ),
                        ));
                        echo '</nav>';
                        }
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        echo '</div>';
    }
    /**
     * Get available menus list
     *
     * @return array
     */
    public function get_available_menus() {

        $raw_menus = wp_get_nav_menus();
        $menus     = wp_list_pluck( $raw_menus, 'name', 'term_id' );

        return $menus;
    }
    /**
     * Returns available icons for dropdown list
     *
     * @return array
     */
    public function dropdown_arrow_icons_list() {

        return apply_filters( 'kitify/nova-menu/dropdown-icons', array(
            ''                             => esc_html__( 'None', 'kitify' ),
            'novaicon-down-arrow'          => esc_html__( 'Angle', 'kitify' ),
            'novaicon-right-arrow'          => esc_html__( 'Angle Right', 'kitify' ),
            'novaicon-small-triangle-down' => esc_html__( 'Triangle', 'kitify' ),
            'novaicon-arrow-down'          => esc_html__( 'Arrow', 'kitify' ),
            'novaicon-i-add'               => esc_html__( 'Plus', 'kitify' ),
            'novaicon-i-add-2'             => esc_html__( 'Plus 2', 'kitify' ),
            'novaicon-e-add'               => esc_html__( 'Plus 3', 'kitify' ),
        ) );

    }
}
?>