<?php

/**
 * Class: Kitify_Dokan_Vendor_Info
 * Name: Dokan Vendor Info
 * Slug: kitify-dokan-vendor-info
 */

namespace Elementor;

if (!defined('WPINC')) {
    die;
}
/**
 * Kitify_Dokan_Vendor_Info Widget
 */
class Kitify_Dokan_Vendor_Info extends Kitify_Base {
    
    /**
     * Get widget name.
     *
     * Retrieve the widget name.
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'kitify-dokan-vendor-info';
    }

    /**
     * Get widget title.
     *
     * Retrieve the widget title.
     *
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__('Dokan Vendor Info', 'kitify');
    }

    /**
     * Get widget icon.
     *
     * Retrieve the widget icon.
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'kitify-icon-author-box';
    }
    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the widget belongs to.
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'kitify-woocommerce' ];
    }
    /**
     * Register widget controls.
     *
     * Add the widget controls.
     */
    protected function _register_controls() {
        if ( ! class_exists( 'WeDevs_Dokan' ) ) {
            return;
        }

        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__( 'Style', 'kitify' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'vendor_info_box',
            [
                'label' => esc_html__( 'Vendor box', 'kitify' ),
                'type' => Controls_Manager::HEADING,
            ]
        );
        $this->add_control(
            'vendor_info_box_background_color',
            [
                'label' => esc_html__( 'Background Color', 'kitify' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dokan-vendor-info-wrap' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'vendor_info_box_border_color',
            [
                'label' => esc_html__( 'Border Color', 'kitify' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dokan-vendor-info-wrap' => 'border-color: {{VALUE}};',
                ],
            ]
        ); 
        $this->add_control(
            'vendor_info_box_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'kitify' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .dokan-vendor-info-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'vendor_info_box_padding',
            [
                'label' => esc_html__( 'Padding', 'kitify' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .dokan-vendor-info-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'vendor_info_box_margin',
            [
                'label' => esc_html__( 'Margin', 'kitify' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .dokan-vendor-info-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'vendor_info_heading',
            [
                'label' => esc_html__( 'Vendor name', 'kitify' ),
                'type' => Controls_Manager::HEADING,
            ]
        );
        $this->add_control(
            'vendor_info_heading_color',
            [
                'label' => esc_html__( 'Color', 'kitify' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dokan-vendor-info-wrap .dokan-vendor-name h5' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            array(
                'name'     => 'vendor_info_heading_typography',
                'label'    => esc_html__( 'Typography', 'kitify' ),
                'selector' => '{{WRAPPER}} .dokan-vendor-info-wrap .dokan-vendor-name h5'
            )
        );
        $this->add_control(
            'vendor_info_rating',
            [
                'label' => esc_html__( 'Vendor rating', 'kitify' ),
                'type' => Controls_Manager::HEADING,
            ]
        );
        $this->add_control(
            'vendor_info_rating_color',
            [
                'label' => esc_html__( 'Color', 'kitify' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dokan-vendor-info-wrap .dokan-vendor-info .dokan-vendor-rating .dashicons-star-filled' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .dokan-vendor-info-wrap .dokan-vendor-info .dokan-vendor-rating .dashicons-star-half' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'vendor_info_rating_count_color',
            [
                'label' => esc_html__( 'Reviews count color', 'kitify' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dokan-vendor-info-wrap .dokan-vendor-info .dokan-vendor-rating .dokan-ratings-count' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            array(
                'name'     => 'vendor_info_rating_typography',
                'label'    => esc_html__( 'Typography', 'kitify' ),
                'selector' => '{{WRAPPER}} .dokan-vendor-info-wrap .dokan-vendor-info .dokan-vendor-rating .dokan-ratings-count'
            )
        );
        $this->end_controls_section();

    }
    /**
     * Render widget output on the frontend.
     *
     * Generate the widget output on the frontend.
     */
    protected function render() {
        global $product;
        $vendor       = dokan_get_vendor_by_product( $product );
        if ( ! $vendor ) {
            return;
        }
        if ( ! dokan_is_user_seller( $vendor->id ) ) {
            return;
        }
        $store_info   = $vendor->get_shop_info();
        $store_rating = $vendor->get_rating();

        dokan_get_template_part(
            'vendor-store-info',
            '',
            [
                'vendor'       => $vendor,
                'store_info'   => $store_info,
                'store_rating' => $store_rating,
            ]
        ); 
    }
}