<?php

/**
 * Class: Kitify_Wcboost_Wishlist
 * Name: WCboost Wishlist Menu
 * Slug: kitify-wcboost-wishlist
 */

namespace Elementor;

if (!defined('WPINC')) {
    die;
}

/**
 * Woo Widget
 */
class Kitify_Wcboost_Wishlist extends Kitify_Base {

    protected function enqueue_addon_resources(){
        $this->add_style_depends( 'kitify-woocommerce' );
        $this->add_script_depends('kitify-base' );
    }

    public function get_name() {
        return 'kitify-wcboost-wishlist';
    }

    public function get_categories() {
        return [ 'kitify-woocommerce' ];
    }


    public function get_widget_title() {
        return esc_html__( 'WCboost Wishlist Menu', 'kitify' );
    }

    public function get_icon() {
        return 'kitify-icon-wishtlist-button';
    }


    protected function register_controls() {
        $css_scheme = \apply_filters(
            'kitify/wcboost-wishlist/css-scheme',
            array(
                'wishlist_box'    => '.kitify__header-wishlist',
                'wishlist_icon'    => '.kitify__header-wishlist .kitify-blocks-icon',
                'wishlist_count'    => '.kitify__header-wishlist .header-counter',            
                'label_text'    => '.kitify__header-wishlist .label-text',            
                )
        );
        $this->start_controls_section(
            'section_settings',
            array(
                'label' => esc_html__( 'Settings', 'kitify' ),
            )
        );
        $this->_add_advanced_icon_control(
            'wishlist_icon',
            array(
                'label'       => esc_html__( 'Icon', 'kitify' ),
                'type'        => Controls_Manager::ICON,
                'label_block' => false,
                'file'        => '',
                'skin'        => 'inline',
                'default'     => 'dlicon ui-3_heart',
                'fa5_default' => array(
                    'value' => 'dlicon ui-3_heart',
                    'library' => 'dlicon',
                ),
            )
        );
        $this->add_control(
        'show_label',
            array(
                'label'        => esc_html__( 'Show Label', 'kitify' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Yes', 'kitify' ),
                'label_off'    => esc_html__( 'No', 'kitify' ),
                'return_value' => 'true',
                'default'      => '',
            )
        );
        $this->add_control(
            'label_text',
            array(
                'label'   => esc_html__( 'Label Text', 'kitify' ),
                'type'    => Controls_Manager::TEXT,
                'default' => esc_html__( 'Wishlist', 'kitify' ),
                'dynamic' => array( 'active' => true ),
                'condition' => array(
                    'show_label' => 'true',
                ),
            )
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_general_style',
            array(
                'label'      => esc_html__( 'General Styles', 'kitify' ),
                'tab'        => Controls_Manager::TAB_STYLE,
                'show_label' => false,
            )
        );
        $this->_add_control(
            'wl_icon_color',
            array(
                'label'  => esc_html__( 'Icon Color', 'kitify' ),
                'type'   => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} ' . $css_scheme['wishlist_icon'] => 'color: {{VALUE}}',
                ),
            ),
            25
        );
        $this->_add_responsive_control(
            'wl_icon_size',
            array(
                'label'      => esc_html__( 'Icon Size', 'kitify' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => array( 'px' ),
                'range'      => array(
                    'px' => array(
                        'min' => 10,
                        'max' => 100,
                    ),
                ),
                'selectors'  => array(
                    '{{WRAPPER}} ' . $css_scheme['wishlist_icon'] => 'font-size: {{SIZE}}{{UNIT}};',
                ),
            ),
            50
        );
        $this->_add_control(
            'wl_count_bg',
            array(
                'label'  => esc_html__( 'Count Background Color', 'kitify' ),
                'type'   => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} ' . $css_scheme['wishlist_count'] => 'background-color: {{VALUE}}',
                ),
                'separator' => 'before',
            ),
            25
        );
        $this->_add_control(
            'wl_count_text',
            array(
                'label'  => esc_html__( 'Count Text Color', 'kitify' ),
                'type'   => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} ' . $css_scheme['wishlist_count'] => 'color: {{VALUE}}',
                ),
            ),
            25
        );
    
        $this->_add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'wl_label_typography',
                'selector' => '{{WRAPPER}} ' . $css_scheme['wishlist_count'],
            ]
        );
        $this->_add_responsive_control(
            'wl_label_top',
            array(
                'label'      => esc_html__( 'Position Top', 'kitify' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => array( 'px','%' ),
                'range'      => array(
                    'px' => array(
                        'min' => -50,
                        'max' => 50,
                    ),
                ),
                'selectors'  => array(
                    '{{WRAPPER}} ' . $css_scheme['wishlist_count'] => 'top: {{SIZE}}{{UNIT}};',
                ),
            ),
            50
        );
        $this->_add_responsive_control(
            'wl_label_left',
            array(
                'label'      => esc_html__( 'Position Left', 'kitify' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => array( 'px','%' ),
                'range'      => array(
                    'px' => array(
                      'min' => -50,
                      'max' => 50,
                    ),
                ),
                'selectors'  => array(
                    '{{WRAPPER}} ' . $css_scheme['wishlist_count'] => 'left: {{SIZE}}{{UNIT}};',
                ),
            ),
            50
        );
        $this->_add_control(
            'label_text_color',
            array(
                'label'  => esc_html__( 'Label Text Color', 'kitify' ),
                'type'   => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} ' . $css_scheme['label_text'] => 'color: {{VALUE}}',
                ),
            ),
            50
        );
        $this->_add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'label_text_typography',
                'selector' => '{{WRAPPER}} ' . $css_scheme['label_text'],
            ]
        );
        $this->end_controls_section();
      
	}

    protected function render() {
        $this->_context = 'render';

        $this->_open_wrap();
        include $this->_get_global_template( 'index' );
        $this->_close_wrap();
    }
	public function wishlist_counter() {
		if ( ! function_exists( 'WC' ) ) {
			return;
		}

		if ( ! class_exists( 'WCBoost\Wishlist\Helper' ) ) {
			return;
		}

		$wishlist = \WCBoost\Wishlist\Helper::get_wishlist();
		$class = '';
        $wishlist_counter = intval( $wishlist->count_items() );

        if ( $wishlist_counter == 0 ) {
            $class =' hidden';
        }

        return sprintf('<span class="header-counter header-wishlist__counter%s">%s</span>', $class, $wishlist_counter);
	}

}
