<?php

/**
 * Class: Kitify_Woo_Single_Product_Rating_Count
 * Name: Product Rating Count
 * Slug: kitify-wooproduct-rating-count
 */

namespace Elementor;

if (!defined('WPINC')) {
    die;
}

/**
 * Woo Widget
 */
class Kitify_Woo_Single_Product_Rating_Count extends Kitify_Base {

    protected function enqueue_addon_resources(){
        $this->add_style_depends( 'kitify-woocommerce' );
        $this->add_script_depends('kitify-base' );
    }

    public function get_name() {
        return 'kitify-wooproduct-rating-count';
    }

    public function get_categories() {
        return [ 'kitify-woo-product' ];
    }

    public function get_keywords() {
        return [ 'woocommerce', 'shop', 'store', 'rating', 'review', 'comments', 'stars', 'product' ];
    }

    public function get_widget_title() {
        return esc_html__( 'Product Rating Count', 'kitify' );
    }

    public function get_icon() {
      return 'kitify-icon-woo-rating';
    }

    protected function register_controls() {
    }
    protected function render() {
        if ( ! post_type_supports( 'product', 'comments' ) ) {
            return;
        }

        global $product;
        $product = wc_get_product();

        if ( empty( $product ) ) {
            return;
        }

        wc_get_template( 'single-product/custom/rating-count.php' );
    }

    public function render_plain_content() {}

}
