<?php
$opt_name = NOVA_FRAMEWORK_VAR;

CSF::createSection( $opt_name, array(
    'title'       => esc_html__('Advanced Settings', 'lumilux-core'),
    'icon'        => 'fa fa-cogs',
    'description' => __('Remember to backup your Theme Options before&nbsp;<b>Update the Theme.</b>', 'lumilux-core'),
    'fields'      => array(
        array(
			'id' => 'enable_open_graph',
			'type' => 'switcher',
			'title' => esc_html__('Enable Meta Tags (Open Graph)', 'lumilux-core'),
            'subtitle' => esc_html__('Example: og:image', 'lumilux-core'),
			'desc' => esc_html__('Enable Open Graph basic support, if you are using Yoast SEO, it is recommended to disable this option.', 'lumilux-core'),
			'default' => 1
		),
		array(
			'id' => 'css_code',
			'type' => 'code_editor',
			'title' => esc_html__('Custom CSS Code', 'lumilux-core'),
			'desc' => esc_html__('e.g. #header{ background: #000; } Dont use &lt;style&gt; tags', 'lumilux-core'),
			'subtitle' => esc_html__('Paste your CSS code here.', 'lumilux-core'),
            'settings' => array(
                'theme'  => 'dracula',
                'mode'   => 'css',
                'tabSize' => 4
            ),
            'sanitize' => false
        ),
        array(
			'id' => 'custom_scripts',
			'type' => 'code_editor',
			'title' => esc_html__('Custom Scripts Below <head>', 'lumilux-core'),
            'desc' => esc_html__('Here you can paste your Google Analytics code (not your id) or Adsense code. If you dont have it or you are already using one, just leave blank.', 'lumilux-core'),
            'settings' => array(
                'theme'  => 'dracula',
                'mode'   => 'htmlmixed',
                'tabSize' => 4
            ),
            'sanitize' => false
        ),
        array(
			'id' => 'custom_scripts_body',
			'type' => 'code_editor',
			'title' => esc_html__('Custom Scripts just after opening <body>', 'lumilux-core'),
            'desc' => esc_html__('Here you can paste your any custom script that will be included on Body with high priority, like Google Tag code.', 'lumilux-core'),
            'settings' => array(
                'theme'  => 'dracula',
                'mode'   => 'htmlmixed',
                'tabSize' => 4
            ),
            'sanitize' => false
        ),
        array(
			'id' => 'custom_scripts_footer',
			'type' => 'code_editor',
			'title' => esc_html__('Custom Scripts on Footer before closing </body>', 'lumilux-core'),
            'desc' => esc_html__('Here you can paste your any custom script that will be included on Footer with less priority.', 'lumilux-core'),
            'settings' => array(
                'theme'  => 'dracula',
                'mode'   => 'htmlmixed',
                'tabSize' => 4
            ),
            'sanitize' => false
        ),
    )
) );
