<?php

$opt_name = NOVA_FRAMEWORK_VAR;

/* Shop Settings */

CSF::createSection( $opt_name, array(
    'id' => 'shop',
    'title' => esc_html__('Shop', 'lumilux-core'),
    'icon' => 'fa fa-shopping-bag'
) );

/* Shop Layout */
CSF::createSection( $opt_name, array(
    'title' => esc_html__('Shop Layout', 'lumilux-core'),
    // 'icon' => 'fa fa-dollar',
    'parent' => 'shop',
	'fields' => array(
    array(
      'id' => 'shop_layout_width',
      'type' => 'button_set',
      'title' => esc_html__('Shop Width', 'lumilux-core'),
      'subtitle' => '',
      'options' => array('boxed' => 'Boxed', 'wide' => 'Wide'),
      'default' => 'boxed',
    ),
    array(
  		'id' => 'shop_sidebar',
  		'type' => 'switcher',
  		'title' => esc_html__('Shop Sidebar', 'lumilux-core'),
  		'default' => 1
    ),
    array(
      'id' => 'shop_sidebar_position',
      'type' => 'button_set',
      'title' => esc_html__('Sidebar Position', 'lumilux-core'),
      'subtitle' => '',
      'options' => array('left' => 'Left', 'right' => 'Right'),
      'default' => 'left',
      'dependency' => array('shop_sidebar', '==', '1'),
    ),
    array(
  		'id' => 'shop_filter_active',
  		'type' => 'switcher',
  		'title' => esc_html__('Shop Filters', 'lumilux-core'),
  		'default' => 1,
      'dependency' => array('shop_sidebar', '==', '0'),
    ),
    array(
      'id' => 'shop_filter_height',
            'type' => 'slider',
      'title' => esc_html__('Widget Scrollbar Max Height', 'lumilux-core'),
      'desc' => esc_html__('Default: 150 pixels.', 'lumilux-core'),
      'default' => '150',
      'min' => '150',
      'step' => '1',
            'max' => '1000',
            'unit' => 'px',
    ),
    array(
      'id' => 'shop_pagination',
      'type' => 'button_set',
      'title' => esc_html__('Pagination', 'lumilux-core'),
      'subtitle' => '',
      'options' => array(
        'default' => 'Classic',
        'load_more_button' => 'Load More',
        'infinite_scroll' => 'Infinite',
      ),
      'default' => 'infinite_scroll',
    ),
    array(
      'id' => 'shop_mobile_columns',
            'type' => 'slider',
      'title' => esc_html__('Number of Columns on Mobile', 'lumilux-core'),
      'desc' => esc_html__('Default: 2', 'lumilux-core'),
      'default' => '2',
      'min' => '1',
      'step' => '1',
            'max' => '2',
            'unit' => '',
    ),
  )
) );

/* Shop Catalog Mode */
CSF::createSection( $opt_name, array(
    'title' => esc_html__('Catalog Mode', 'lumilux-core'),
    // 'icon' => 'fa fa-dollar',
    'parent' => 'shop',
	'fields' => array(
    array(
  		'id' => 'catalog_mode',
  		'type' => 'switcher',
  		'title' => esc_html__('Catalog Mode', 'lumilux-core'),
  		'default' => 0
    ),
    array(
      'id' => 'catalog_mode_price',
      'type' => 'switcher',
      'dependency' => array('catalog_mode', '==', '1'),
      'title' => esc_html__('Remove Product Price', 'lumilux-core'),
      'default' => 0
    ),
  )
) );

/* Shop Archives */
CSF::createSection( $opt_name, array(
    'title' => esc_html__('Shop Archives', 'lumilux-core'),
    // 'icon' => 'fa fa-dollar',
    'parent' => 'shop',
	'fields' => array(
    array(
      'id' => 'title_general',
       'type' => 'subheading',
      'title' => __( 'General', 'lumilux-core')
    ),
    array(
      'id' => 'shop_product_columns',
            'type' => 'slider',
      'title' => esc_html__('Number of Columns', 'lumilux-core'),
      'desc' => esc_html__('Default: 3', 'lumilux-core'),
      'default' => '3',
      'min' => '1',
      'step' => '1',
            'max' => '6',
            'unit' => '',
    ),
    array(
      'id'      => 'product_per_page_allow',
      'type'    => 'text',
      'title'   => esc_html__( 'WooCommerce Number of Products per Page Allow', 'lumilux-core' ),
      'default' => esc_html__( '12,15,30', 'lumilux-core' ),
      'desc' => esc_html__('Comma-separated. ( i.e: 3,6,9 )', 'lumilux-core'),
    ),
    array(
      'id' => 'shop_product_per_page',
      'type' => 'slider',
      'title' => esc_html__( 'WooCommerce Number of Products per Page', 'lumilux-core' ),
      'description' => esc_html__('The value of field must be as one value of setting above.', 'lumilux'),
      'default' => '12',
      'min' => '1',
      'step' => '1',
            'max' => '100',
            'unit' => '',
    ),
    array(
      'id' => 'shop_product_addtocart_button',
      'type' => 'switcher',
      'title' => esc_html__('Show add to cart button', 'lumilux-core'),
      'default' => 1
    ),
    array(
      'id' => 'shop_product_wishlist_button',
      'type' => 'switcher',
      'title' => esc_html__('Show Wishlist button', 'lumilux-core'),
      'default' => 1
    ),
    array(
      'id' => 'shop_product_quickview_button',
      'type' => 'switcher',
      'title' => esc_html__('Show Quickview button', 'lumilux-core'),
      'default' => 1
    ),
    array(
      'id' => 'shop_second_image',
      'type' => 'switcher',
      'title' => esc_html__('Product Image on Hover', 'lumilux-core'),
      'default' => 0
    ),
    array(
      'id' => 'title_toolbar',
       'type' => 'subheading',
      'title' => __( 'Toolbar', 'lumilux-core')
    ),
    array(
      'id' => 'shop_toolbar_grid_list',
      'type' => 'switcher',
      'title' => esc_html__('Show Grid List Switch', 'lumilux-core'),
      'default' => 1
    ),
    array(
      'id' => 'title_sale',
       'type' => 'subheading',
      'title' => __( 'Sale Badge', 'lumilux-core')
    ),
    array(
      'id' => 'sale_page_badge_type',
      'type' => 'switcher',
      'title' => esc_html__('Show Discount percentage', 'lumilux-core'),
      'default' => 0
    ),
    array(
      'id'      => 'sale_page_badge_text',
      'type'    => 'text',
      'title'   => esc_html__( 'Sale Badge Wording', 'lumilux-core' ),
      'default' => esc_html__( 'Sale!', 'lumilux-core' ),
    ),
    array(
      'id' => 'title_new',
       'type' => 'subheading',
      'title' => __( 'New Badge', 'lumilux-core')
    ),
    array(
      'id' => 'new_products_badge',
      'type' => 'switcher',
      'title' => esc_html__('New badge', 'lumilux-core'),
      'default' => 1
    ),
    array(
      'id'      => 'new_products_badge_text',
      'type'    => 'text',
      'title'   => esc_html__( 'New Products Badge Wording', 'lumilux-core' ),
      'default' => esc_html__( 'New!', 'lumilux-core' ),
      'dependency' => array('new_products_badge', '==', '1'),
    ),
    array(
      'id' => 'new_products_number_type',
      'type' => 'button_set',
      'title' => esc_html__('Show new products by:', 'lumilux-core'),
      'subtitle' => '',
      'dependency' => array('new_products_badge', '==', '1'),
      'options' => array(
        'day' => 'Day Added',
        'last_added' => 'Last Added',
      ),
      'default' => 'last_added',
    ),
    array(
      'id' => 'new_products_number',
      'type' => 'slider',
      'title' => esc_html__('Show products added in the past <i>x</i> days:', 'lumilux-core'),
      'desc' => esc_html__('Default: 8', 'lumilux-core'),
      'dependency' => array(
        array('new_products_badge', '==', '1'),
        array('new_products_number_type', '==', 'day'),
      ),
      'default' => '8',
      'min' => '1',
      'step' => '1',
            'max' => '360',
            'unit' => '',
    ),
    array(
      'id' => 'new_products_number_last',
      'type' => 'slider',
      'title' => esc_html__('Show last <i>x</i> products:', 'lumilux-core'),
      'desc' => esc_html__('Default: 8', 'lumilux-core'),
      'dependency' => array(
        array('new_products_badge', '==', '1'),
        array('new_products_number_type', '==', 'last_added'),
      ),
      'default' => '8',
      'min' => '1',
      'step' => '1',
            'max' => '20',
            'unit' => '',
    ),
  )
) );

/* Shop Single */
CSF::createSection( $opt_name, array(
    'title' => esc_html__('Shop Single', 'lumilux-core'),
    // 'icon' => 'fa fa-dollar',
    'parent' => 'shop',
	'fields' => array(
    array(
      'id' => 'general_title',
       'type' => 'subheading',
      'title' => __( 'General', 'lumilux-core')
    ),
    array(
      'id' => 'single_product_sidebar',
      'type' => 'switcher',
      'title' => esc_html__('Single Product Sidebar', 'lumilux-core'),
      'default' => 0
    ),
    array(
      'id' => 'single_product_sidebar_position',
      'type' => 'button_set',
      'title' => esc_html__('Sidebar Position', 'lumilux-core'),
      'subtitle' => '',
      'options' => array('left' => 'Left', 'right' => 'Right'),
      'default' => 'right',
      'dependency' => array('single_product_sidebar', '==', '1'),
    ),
    array(
      'id' => 'single_product_social_share',
      'type' => 'switcher',
      'title' => esc_html__('Display Social Share', 'lumilux-core'),
      'default' => 0
    ),
    array(
      'id' => 'upsell_products',
      'type' => 'switcher',
      'title' => esc_html__('Up-sells Display', 'lumilux-core'),
      'default' => 0
    ),
    array(
      'id' => 'related_products',
      'type' => 'switcher',
      'title' => esc_html__('Related Products Display', 'lumilux-core'),
      'default' => 1
    ),
    array(
      'id' => 'related_products_column',
      'type' => 'slider',
      'title' => esc_html__('Number of Related Products', 'lumilux-core'),
      'desc' => esc_html__('Default: 4', 'lumilux-core'),
      'dependency' => array(
        array('related_products', '==', '1'),
      ),
      'default' => '4',
      'min' => '2',
      'step' => '1',
            'max' => '6',
            'unit' => '',
    ),
    array(
      'id' => 'image_gallery',
       'type' => 'subheading',
      'title' => __( 'Image Gallery', 'lumilux-core')
    ),
    array(
      'id' => 'product_image_zoom',
      'type' => 'switcher',
      'title' => esc_html__('Image Zoom', 'lumilux-core'),
      'desc' => esc_html__( 'Zooms in where your cursor is on the image', 'lumilux' ),
      'default' => 1
    ),
    array(
      'id' => 'product_image_lightbox',
      'type' => 'switcher',
      'title' => esc_html__('Image Lightbox', 'lumilux-core'),
      'desc' => esc_html__( 'Opens your images against a dark backdrop', 'lumilux' ),
      'default' => 1
    ),
  )
) );
