<?php

$opt_name = NOVA_FRAMEWORK_VAR;

$primary_color = '#EA445A';
$titles_color = '#1A1A1A';
$text_color = '#3D3D3D';
$border_color = '#E9E9E9';
$input_bg_color = '#FFFFFF';
$background_color = '#FFFFFF';
$content_bg_color = '#FFFACD';
$black = '#000000';
$white = '#FFFFFF';
$s_button_color = '#1A1A1A';
$header_notice_color = '#1A1A1A';
/* Blog */

CSF::createSection( $opt_name, array(
	'title' => esc_html__('Styling', 'lumilux-core'),
    'icon' => 'fa fa-pencil',
    'id' => 'styling'
) );

/* Basic Styling */

CSF::createSection( $opt_name, array(
	'title' => esc_html__('Basic Styling', 'lumilux-core'),
    // 'icon' => 'el-icon-pencil',
    'parent' => 'styling',
	'fields' => array(
				array(
					'id' => 'bg_color',
					'type' => 'color',
					'title' => esc_html__('Body Background Color ', 'lumilux-core'),
					'default' => $background_color,
					'subtitle' =>  esc_html__("Default: ".$background_color, 'lumilux-core'),
								'desc' =>  esc_html__('Body background color', 'lumilux-core'),
								'transparent' => false,
								'class' => 'nova-hide-transparent',
								'validate' => 'csf_validate_hex_color_transparent',
				),
      array(
				'id' => 'primary_color',
				'type' => 'color',
				'title' => esc_html__('Primary color ', 'lumilux-core'),
				'default' => $primary_color,
				'subtitle' =>  esc_html__("Default: ".$primary_color, 'lumilux-core'),
	            'desc' =>  esc_html__('Accent color', 'lumilux-core'),
	            'transparent' => false,
	            'class' => 'nova-hide-transparent',
	            'validate' => 'csf_validate_hex_color_transparent',
		),

    array(
			'id' => 'titles_color',
			'type' => 'color',
			'title' => esc_html__('Titles Color', 'lumilux-core'),
			'default' => $titles_color,
			'subtitle' =>  esc_html__("Default: ".$titles_color, 'lumilux-core'),
            // 'desc' =>  esc_html__('Buttons, main links, etc', 'lumilux-core'),
			// 'validate' => 'color',
            'transparent' => false,
            'class' => 'nova-hide-transparent',
            'validate' => 'csf_validate_hex_color_transparent',
		),
		array(
			'id' => 'text_color',
			'type' => 'color',
			'title' => esc_html__('Text Color', 'lumilux-core'),
			'default' => $text_color,
			'subtitle' =>  esc_html__("Default: ".$text_color, 'lumilux-core'),
			//'validate' => 'color',
            'transparent' => false,
            'class' => 'nova-hide-transparent',
            'validate' => 'csf_validate_hex_color_transparent',
        ),
		array(
			'id' => 'border_color',
			'type' => 'color',
			'title' => esc_html__('Border Color', 'lumilux-core'),
			'default' => $border_color,
			'subtitle' =>  esc_html__("Default: ".$border_color, 'lumilux-core'),
			//'validate' => 'color',
            'transparent' => false,
            'class' => 'nova-hide-transparent',
            'validate' => 'csf_validate_hex_color_transparent',
        ),
	)
) );
/* Buttons */

CSF::createSection( $opt_name, array(
	'title' => esc_html__('Buttons/Links', 'lumilux-core'),
    // 'icon' => 'el-icon-edit',
    'parent' => 'styling',
	'fields' => array(
        array(
			'id' => 'content_link_color',
			'type' => 'link_color',
			'title' => esc_html__('General link color', 'lumilux-core'),
			'subtitle' => esc_html__("Default: $black, Hover: $text_color", 'lumilux-core'),
			// 'validate' => 'color',
			'active' => false,
			'default' => array(
				'color' => $black,
                'hover' => $text_color,
			),
            'class' => 'nova-hide-transparent',
        ),
        array(
			'id' => 'primary_button',
			'type' => 'color_group',
			'title' => esc_html__('Primary Button', 'lumilux-core'),
			'default' => $white,
            'subtitle' => esc_html__("Default: $primary_color, Text: $white", 'lumilux-core'),
            'transparent' => false,
            // 'validate' => 'csf_validate_hex_color',
            'class' => 'nova-hide-transparent',
            'options' => array(
                'background' => 'Background',
                'text_color' => 'Text Color',
            ),
            'default' => array(
                'background' => $primary_color,
                'text_color' => $white,
            )
        ),
        array(
			'id' => 'secondary_button',
			'type' => 'color_group',
			'title' => esc_html__('Secondary Button', 'lumilux-core'),
			'default' => $s_button_color,
            'subtitle' => esc_html__("Default: $black, Text: $white", 'lumilux-core'),
            'transparent' => false,
            // 'validate' => 'csf_validate_hex_color',
            'class' => 'nova-hide-transparent',
            'options' => array(
                'background' => 'Background',
                'text_color' => 'Text Color',
            ),
            'default' => array(
                'background' => $s_button_color,
                'text_color' => $white,
            )
        ),
		array(
			'id' => 'button_radius',
						'type' => 'slider',
			'title' => esc_html__('Button radius', 'lumilux-core'),
			'desc' => esc_html__('Default: 0 pixels.', 'lumilux-core'),
			'default' => '0',
			'min' => '0',
			'step' => '1',
						'max' => '100',
						'unit' => 'px',
		),
	)
) );


/* Forms */

CSF::createSection( $opt_name, array(
	'title' => esc_html__('Forms', 'lumilux-core'),
    // 'icon' => 'el-icon-edit',
    'parent' => 'styling',
	'fields' => array(
        array(
            'id'   => 'info_forms',
            'type' => 'subheading',
            'title' => esc_html__('Important:', 'lumilux-core'),
            'subtitle' => esc_html__('All these options affects contact and comments form.', 'lumilux-core')
        ),
		array(
			'id' => 'field_radius',
						'type' => 'slider',
			'title' => esc_html__('Field radius', 'lumilux-core'),
			'desc' => esc_html__('Default: 0 pixels.', 'lumilux-core'),
			'default' => '0',
			'min' => '0',
			'step' => '1',
						'max' => '100',
						'unit' => 'px',
		),
        array(
			'id' => 'input_bg_color',
			'type' => 'color',
			'title' => esc_html__('Input box background color', 'lumilux-core'),
			'default' => $input_bg_color,
            'subtitle' =>  esc_html__('Default: '.$input_bg_color, 'lumilux-core'),
			// 'validate' => 'color',
			'transparent' => false
        ),
        array(
			'id' => 'input_text_color',
			'type' => 'color',
			'title' => esc_html__('Input box text color', 'lumilux-core'),
			'default' => $text_color,
            'subtitle' =>  esc_html__('Default: '.$text_color, 'lumilux-core'),
			// 'validate' => 'color',
			'transparent' => false
        ),
        array(
			'id' => 'label_text_color',
			'type' => 'color',
			'title' => esc_html__('Label text color', 'lumilux-core'),
			'default' => $text_color,
            'subtitle' =>  esc_html__('Default: '.$text_color, 'lumilux-core'),
			// 'validate' => 'color',
			'transparent' => false
        ),
        array(
			'id' => 'submit_bg_color',
			'type' => 'color',
			'title' => esc_html__('Submit button background color', 'lumilux-core'),
			'default' => $primary_color,
            'subtitle' =>  esc_html__("Default: ".$primary_color, 'lumilux-core'),
			// 'validate' => 'color',
            'transparent' => false,
            // 'class' => 'nova-hide-transparent',
            'validate' => 'csf_validate_hex_color',
        ),
        array(
			'id' => 'submit_text_color',
			'type' => 'color',
			'title' => esc_html__('Submit button text color', 'lumilux-core'),
			'default' => $white,
            'subtitle' =>  esc_html__('Default: '.$white, 'lumilux-core'),
			// 'validate' => 'color',
			'transparent' => false
        ),
	)
) );

