<?php
$opt_name = NOVA_FRAMEWORK_VAR;

/* Typography */

CSF::createSection( $opt_name, array(
	'title' => esc_html__('Typography', 'lumilux-core'),
	'icon' => 'fa fa-font',
	'fields' => array(

		array(
			'id' => 'general_fonts',
			'type' => 'subheading',
			'title' => __('Generals Fonts', 'lumilux-core'),
			'subtitle' => __('Global font families for all sections, including pages, posts, sidebar and footer.', 'lumilux-core'),
			'indent' => true
		),
		array(
			'id' => 'body_font',
			'type' => 'typography',
			'title' => esc_html__('Regular Text Font', 'lumilux-core'),
			'subtitle' => esc_html__('Default: brother-1816, 16px normal', 'lumilux-core'),
			'google' => true,
			'subset' => true,
			'font_size' => true,
			'line_height' => false,
            'text_align' => false,
            'text_transform' => false,
            'letter_spacing' => false,
			'color' => false,
			'default' => array(
				'font-size' => '16',
				'font-family' => '',
				'font-weight' => ''
			)
		),
		array(
			'id' => 'primary_titles_font',
			'type' => 'typography',
			'title' => esc_html__('Primary Titles Font Family', 'lumilux-core'),
			'subtitle' => esc_html__('Default: Bellefair, Regular (400)', 'lumilux-core'),
			'desc' => esc_html__('e.g. Article titles, box titles, page titles, etc.', 'lumilux-core'),
			'google' => true,
			'subset' => true,
            'font_size' => false,
			'line_height' => false,
            'text_align' => false,
            'text_transform' => false,
            'letter_spacing' => false,
			'color' => false,
			'default' => array(
				'font-family' => '',
				'font-weight' => '',
			)
		),

	)
) );
